%% Read in the data from the exel sheet
clear;
filename = 'usmodel_data_19472017.xls';
sheet = 'Sheet1';
xlRange = 'A1:I168';
data = xlsread(filename,sheet,xlRange)

%% Plot the raw data
f = figure;
p = uipanel('Parent',f,'BorderType','none'); 
p.Title = 'Raw Data'; 
p.TitlePosition = 'centertop'; 
p.FontSize = 12;
p.FontWeight = 'bold';

% Create time variable
startDate = datenum('01-01-1966');
endDate = datenum('12-31-2007');
date = linspace(startDate,endDate,167);
dateformat = 'yy';
datetick('x',dateformat,'keepticks');


%date = data(:,1);

subplot(4,2,1,'Parent',p) 
plot(date,data(:,4));
dateformat = 'yy';
datetick('x',dateformat,'keepticks');
title('Output') 

subplot(4,2,2,'Parent',p) 
plot(date,data(:,2));
dateformat = 'yy';
datetick('x',dateformat,'keepticks');
title('Consumption')

subplot(4,2,3,'Parent',p) 
plot(date,data(:,3));
dateformat = 'yy';
datetick('x',dateformat,'keepticks');
title('Investment')

subplot(4,2,4,'Parent',p) 
plot(date,data(:,5));
dateformat = 'yy';
datetick('x',dateformat,'keepticks');
title('Hours')

subplot(4,2,5,'Parent',p) 
plot(date,data(:,6));
dateformat = 'yy';
datetick('x',dateformat,'keepticks');
title('Inflation')

subplot(4,2,6,'Parent',p) 
plot(date,data(:,7));
dateformat = 'yy';
datetick('x',dateformat,'keepticks');
title('Real Wage')

subplot(4,2,7,'Parent',p) 
plot(date,data(:,8));
dateformat = 'yy';
datetick('x',dateformat,'keepticks');
title('Interest Rate')

subplot(4,2,8,'Parent',p) 
plot(date,data(:,9));
dateformat = 'yy';
datetick('x',dateformat,'keepticks');
title('Spread')

% Filtered Output
[~, outputhp] = hpfilter(data(:,4),1600);
outputfd = diff(data(:,4));
outputlt = detrend(data(:,4));
outputlt = outputlt-data(:,4);

figure;
plot(date(2:end), outputfd);
hold on
plot(date((2:end)), outputhp(2:end))
plot(date(2:end), outputlt(2:end));
datetick('x',dateformat,'keepticks');
title('Output')
legend('FD','HP','LT')
hold off




